function z=njutn(x,y,spol,novx,novy)
%NJUTN vraca Njutnov polinom
%nx=njutn(x,y)
%nx - Njutnov polinom kao vektor keoficijenata polinoma sa 0-tim clanom na poziciji 1
%x - vektor cvorova nad kojim se radi interpolacija
%y - vektor vrijednosti funkcije u cvorovima

nx=size(x,2);
global BrRacOp

if nargin<3
	tab=podrazlike(x,y);
	z=[tab(1,1) zeros(1,nx-1)];
    omega=[-x(1) 1];
    a=2;
    b=nx;
else
    temp1=BrRacOp;
    temp2=podrazlike(x,y);
    BrRacOp=temp1;
    tab=podrazlike(x,y,temp2,novx,novy);
    clear temp1 temp2;
    novn=size(novx,2);
    z=[spol zeros(1,novn)];
    x=[x novx];
    y=[y novy];
    omega=[-x(1) 1];
    for i=2:nx
        omega=mnozpol(omega,[-x(i) 1]);
    end
    a=nx+1;
    b=nx+novn;
    kont=1;
end

for i=a:b
    z=z+(tab(1,i))*[omega zeros(1,b-i)];
    omega=mnozpol(omega,[-x(i) 1]);
    BrRacOp=BrRacOp+2*size(omega,2)-1;
end
